/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.TreeSet;
import org.python.indexer.Indexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String UTF_8 = "UTF-8";
    private static int gensymCount = -1;

    public static String gensym(String string) {
        return string + ++gensymCount;
    }

    public static String getSystemTempDir() {
        String string;
        String string2 = System.getProperty("java.io.tmpdir");
        if (string2.endsWith(string = System.getProperty("file.separator"))) {
            return string2;
        }
        return string2 + string;
    }

    public static String getQnameParent(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String moduleQname(String string) {
        boolean bl = string.endsWith("/__init__.py");
        if (bl) {
            string = string.substring(0, string.length() - "/__init__.py".length());
        } else if (string.endsWith(".py")) {
            string = string.substring(0, string.length() - ".py".length());
        }
        for (String string2 : Indexer.idx.getLoadPath()) {
            if (!string.startsWith(string2)) continue;
            return string.substring(string2.length()).replace('/', '.');
        }
        return null;
    }

    public static String arrayToString(Collection<String> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : collection) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    public static String arrayToSortedStringSet(Collection<String> collection) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(collection);
        return Util.arrayToString(treeSet);
    }

    public static String moduleNameFor(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            throw new IllegalStateException("failed assertion: " + string);
        }
        String string2 = file.getName();
        if (string2.equals("__init__.py")) {
            return file.getParentFile().getName();
        }
        return string2.substring(0, string2.lastIndexOf(46));
    }

    public static File joinPath(File file, String string) {
        return Util.joinPath(file.getAbsolutePath(), string);
    }

    public static File joinPath(String string, String string2) {
        if (string.endsWith("/")) {
            return new File(string + string2);
        }
        return new File(string + "/" + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String string, String string2) throws Exception {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            printWriter.print(string2);
            printWriter.flush();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static String readFile(String string) throws Exception {
        return Util.readFile(new File(string));
    }

    public static String readFile(File file) throws Exception {
        return new String(Util.getBytesFromFile(file), UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            int n;
            fileInputStream = new FileInputStream(file);
            long l = file.length();
            if (l > Integer.MAX_VALUE) {
                throw new IOException("file too large: " + file);
            }
            byte[] byArray = new byte[(int)l];
            int n2 = 0;
            for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
            }
            if (n < byArray.length) {
                throw new IOException("Failed to read whole file " + file);
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static String getMD5(File file) throws Exception {
        byte[] byArray = Util.getBytesFromFile(file);
        return Util.getMD5(byArray);
    }

    public static String getMD5(byte[] byArray) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        messageDigest.reset();
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray2.length; ++i) {
            stringBuilder.append(String.format("%02x", 0xFF & byArray2[i]));
        }
        return stringBuilder.toString();
    }

    public static String canonicalize(String string) {
        File file = new File(string);
        string = file.getAbsolutePath();
        if (file.isDirectory() && !string.endsWith("/")) {
            return string + "/";
        }
        return string;
    }

    static boolean isReadableFile(String string) {
        File file = new File(string);
        return file.canRead() && file.isFile();
    }
}

